/*
 * Decompiled with CFR 0.152.
 */
package net.unusual.blockfactorysbosses.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.unusual.blockfactorysbosses.client.model.Modelunderworld_knight;
import net.unusual.blockfactorysbosses.entity.UnderworldKnightEntity;
import net.unusual.blockfactorysbosses.init.BlockFactorysBossesModParticleTypes;
import net.unusual.blockfactorysbosses.network.BlockFactorysBossesModVariables;
import net.unusual.blockfactorysbosses.procedures.UnderworldKnightDisplayConditionProcedure;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

public class UnderworldKnightRenderer
extends MobRenderer<UnderworldKnightEntity, Modelunderworld_knight<UnderworldKnightEntity>> {
    public UnderworldKnightRenderer(EntityRendererProvider.Context context) {
        super(context, new Modelunderworld_knight(context.bakeLayer(Modelunderworld_knight.LAYER_LOCATION)), 0.0f);
        this.addLayer(new ItemInHandLayer(this));
        this.addLayer((RenderLayer)new RenderLayer<UnderworldKnightEntity, Modelunderworld_knight<UnderworldKnightEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"block_factorys_bosses:textures/entities/underworld_knight_glow.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, UnderworldKnightEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (UnderworldKnightDisplayConditionProcedure.execute((Entity)entity) && !entity.isInvisible()) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    ((Modelunderworld_knight)this.getParentModel()).renderToBuffer(poseStack, vertexConsumer, 0xF000F0, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(UnderworldKnightEntity entity) {
        return ResourceLocation.parse((String)"block_factorys_bosses:textures/entities/underworld_knight.png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ItemInHandLayer<T extends LivingEntity, M extends EntityModel<T>>
    extends RenderLayer<T, M> {
        public ItemInHandLayer(RenderLayerParent<T, M> layer) {
            super(layer);
        }

        public void render(@NotNull PoseStack pose, @NotNull MultiBufferSource bufferSource, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            int attack_animtime = (Integer)entity.getEntityData().get(UnderworldKnightEntity.DATA_attack_animtime);
            int attack_phase = (Integer)entity.getEntityData().get(UnderworldKnightEntity.DATA_attack_phase);
            if (!Minecraft.getInstance().isPaused()) {
                Vector3f translation;
                Vec3 cameraPos;
                Modelunderworld_knight model;
                EntityModel entityModel;
                if ((Integer)entity.getEntityData().get(UnderworldKnightEntity.DATA_spawn_animtime) > 0 && (Integer)entity.getEntityData().get(UnderworldKnightEntity.DATA_spawn_animtime) <= 236 || (Integer)entity.getEntityData().get(UnderworldKnightEntity.DATA_undead_cinematic) > 0 && (Integer)entity.getEntityData().get(UnderworldKnightEntity.DATA_undead_cinematic) <= 80) {
                    pose.pushPose();
                    entityModel = this.getParentModel();
                    if (entityModel instanceof Modelunderworld_knight) {
                        model = (Modelunderworld_knight)entityModel;
                        model.translateToBody(pose);
                    }
                    pose.translate(0.0f, 0.0f, 0.0f);
                    pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pose.scale(1.0f, 1.0f, 1.0f);
                    cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    translation = new Vector3f();
                    pose.last().pose().getTranslation(translation);
                    BlockFactorysBossesModVariables.cinematicX = (double)translation.x() + cameraPos.x;
                    BlockFactorysBossesModVariables.cinematicY = (double)translation.y() + cameraPos.y;
                    BlockFactorysBossesModVariables.cinematicZ = (double)translation.z() + cameraPos.z;
                    pose.popPose();
                    if ((Integer)entity.getEntityData().get(UnderworldKnightEntity.DATA_spawn_animtime) == 61) {
                        pose.pushPose();
                        entityModel = this.getParentModel();
                        if (entityModel instanceof Modelunderworld_knight) {
                            model = (Modelunderworld_knight)entityModel;
                            model.translateToBody(pose);
                        }
                        pose.translate(0.0, 0.0, 0.0);
                        pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                        pose.scale(1.0f, 1.0f, 1.0f);
                        cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                        translation = new Vector3f();
                        pose.last().pose().getTranslation(translation);
                        entity.level().addParticle((ParticleOptions)BlockFactorysBossesModParticleTypes.SOUL_CLOUD.get(), (double)translation.x() + cameraPos.x, (double)translation.y() + cameraPos.y, (double)translation.z() + cameraPos.z, (0.5 - Math.random()) * 1.8, Math.random() * 0.4, (0.5 - Math.random()) * 1.8);
                        entity.level().addParticle((ParticleOptions)BlockFactorysBossesModParticleTypes.BLACK_FALLING_DUST.get(), (double)translation.x() + cameraPos.x, (double)translation.y() + cameraPos.y, (double)translation.z() + cameraPos.z, (0.5 - Math.random()) * 1.6, Math.random() * 0.4, (0.5 - Math.random()) * 1.6);
                        pose.popPose();
                    }
                }
                if (attack_phase == 0 || attack_phase == 1) {
                    if (attack_phase == 0 && (attack_animtime > 119 && attack_animtime < 122 || attack_animtime > 73 && attack_animtime < 76 || attack_animtime > 55 && attack_animtime < 58) || attack_phase == 1 && (attack_animtime > 50 && attack_animtime < 53 || attack_animtime > 23 && attack_animtime < 26)) {
                        pose.pushPose();
                        entityModel = this.getParentModel();
                        if (entityModel instanceof Modelunderworld_knight) {
                            model = (Modelunderworld_knight)entityModel;
                            model.translateToDagger(pose);
                        }
                        pose.translate(0.0, 0.0, 0.0);
                        pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                        pose.scale(1.0f, 1.0f, 1.0f);
                        cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                        translation = new Vector3f();
                        pose.last().pose().getTranslation(translation);
                        entity.level().addParticle((ParticleOptions)BlockFactorysBossesModParticleTypes.MAGICAL_DOT.get(), (double)translation.x() + cameraPos.x, (double)translation.y() + cameraPos.y, (double)translation.z() + cameraPos.z, (0.5 - Math.random()) * 0.4, (0.5 - Math.random()) * 0.4, (0.5 - Math.random()) * 0.4);
                        pose.popPose();
                    } else if (attack_phase == 0 && (attack_animtime > 106 && attack_animtime < 108 || attack_animtime > 92 && attack_animtime < 94 || attack_animtime > 60 && attack_animtime < 62) || attack_phase == 1 && (attack_animtime > 110 && attack_animtime < 113 || attack_animtime > 69 && attack_animtime < 72 || attack_animtime > 30 && attack_animtime < 33)) {
                        pose.pushPose();
                        entityModel = this.getParentModel();
                        if (entityModel instanceof Modelunderworld_knight) {
                            model = (Modelunderworld_knight)entityModel;
                            model.translateToSword(pose);
                        }
                        pose.translate(0.0, 0.0, 0.0);
                        pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                        pose.scale(1.0f, 1.0f, 1.0f);
                        cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                        translation = new Vector3f();
                        pose.last().pose().getTranslation(translation);
                        entity.level().addParticle((ParticleOptions)BlockFactorysBossesModParticleTypes.MAGICAL_DOT.get(), (double)translation.x() + cameraPos.x, (double)translation.y() + cameraPos.y, (double)translation.z() + cameraPos.z, (0.5 - Math.random()) * 0.4, (0.5 - Math.random()) * 0.4, (0.5 - Math.random()) * 0.4);
                        pose.popPose();
                    }
                }
                if ((Integer)entity.getEntityData().get(UnderworldKnightEntity.DATA_boss_phase) > -1) {
                    pose.pushPose();
                    entityModel = this.getParentModel();
                    if (entityModel instanceof Modelunderworld_knight) {
                        model = (Modelunderworld_knight)entityModel;
                        model.translateToBody(pose);
                    }
                    pose.translate(0.0, 0.0, 0.0);
                    pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pose.scale(1.0f, 1.0f, 1.0f);
                    cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    translation = new Vector3f();
                    pose.last().pose().getTranslation(translation);
                    if (Math.random() < 0.005) {
                        entity.level().addParticle((ParticleOptions)BlockFactorysBossesModParticleTypes.SOUL_SMOKE.get(), (double)translation.x() + cameraPos.x, (double)translation.y() + cameraPos.y, (double)translation.z() + cameraPos.z, (0.5 - Math.random()) * 1.8, (0.5 - Math.random()) * 1.8, (0.5 - Math.random()) * 1.8);
                    }
                    pose.popPose();
                    pose.pushPose();
                    entityModel = this.getParentModel();
                    if (entityModel instanceof Modelunderworld_knight) {
                        model = (Modelunderworld_knight)entityModel;
                        model.translateToHead(pose);
                    }
                    pose.translate(0.0, 0.0, 0.0);
                    pose.mulPose(Axis.XP.rotationDegrees(90.0f));
                    pose.scale(1.0f, 1.0f, 1.0f);
                    cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    translation = new Vector3f();
                    pose.last().pose().getTranslation(translation);
                    if (Math.random() < 0.0025) {
                        entity.level().addParticle((ParticleOptions)BlockFactorysBossesModParticleTypes.SOUL_SMOKE.get(), (double)translation.x() + cameraPos.x, (double)translation.y() + cameraPos.y, (double)translation.z() + cameraPos.z, (0.5 - Math.random()) * 1.8, (0.5 - Math.random()) * 1.8, (0.5 - Math.random()) * 1.8);
                    }
                    pose.popPose();
                }
            }
        }
    }
}

